﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Word = Microsoft.Office.Interop.Word;

namespace WordAutomatyzacja
{
    public partial class Form1 : Form
    {
        Word.Application oApp;

        public Form1()
        {
            InitializeComponent();            
        }

        private void button1_Click(object sender, EventArgs e)
        {            
            oApp = new Word.Application();
            oApp.Documents.Add();
            oApp.Visible = true;            
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {

        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    if (oApp == null)
                        oApp = new Word.Application();

                    oApp.Documents.Open(openFileDialog1.FileName);
                    oApp.Visible = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show("W trakcie próby otwarcia pliku:\n"
                        + openFileDialog1.FileName
                        + "błąd:\n" + ex.Message,
                        this.Name);
                }
            }            
        }

        private void button3_Click(object sender, EventArgs e)
        {            
            try
            {
                oApp = (Word.Application)System.Runtime.InteropServices.
                    Marshal.GetActiveObject("Word.Application");
                oApp.Visible = true;
                oApp.ActiveDocument.CheckSpelling();

                // oApp.PrintPreview = true;
                // oApp.PrintOut();

            }
            catch(Exception ex)
            {
                MessageBox.Show("W trakcie próby sprawdzenia pisowni wystąpił błąd\n"                        
                    + ex.Message, this.Name);
            }        
        }

        private void button4_Click(object sender, EventArgs e)
        {
            try
            {
                oApp = (Word.Application)System.Runtime.InteropServices.
                    Marshal.GetActiveObject("Word.Application");
                oApp.Visible = true;
                oApp.Selection.TypeText(textBox1.Text);
            }
            catch (Exception ex)
            {
                MessageBox.Show("W trakcie próby wstawienia napisu wystąpił błąd:\n"
                    + ex.Message, this.Name);
            }        
        }

        private void button5_Click(object sender, EventArgs e)
        {
            try
            {
                oApp = (Word.Application)System.Runtime.InteropServices.
                    Marshal.GetActiveObject("Word.Application");

                oApp.ActiveDocument.Save();                
            }
            catch (Exception ex)
            {
                MessageBox.Show("Zapisanie aktywnego dokumentu nie powiodło się:\n"
                    + ex.Message);
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            try
            {
                oApp = (Word.Application)System.Runtime.InteropServices.
                    Marshal.GetActiveObject("Word.Application");

                Word.Range range = oApp.ActiveDocument.Range();
                
                range.Select();
                range.Copy();                
            }
            catch (Exception ex)
            {
                MessageBox.Show("Skopiowanie zawartości dokumentu do schowka nie powiodło się:\n"
                    + ex.Message);
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            try
            {
                oApp = (Word.Application)System.Runtime.InteropServices.
                    Marshal.GetActiveObject("Word.Application");

                Word.Range range = oApp.ActiveDocument.Range();

                richTextBox1.Text = range.Text;                
            }
            catch (Exception ex)
            {
                MessageBox.Show("Skopiowanie zawartości dokumentu nie powiodło się:\n"
                    + ex.Message);
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            oApp = (Word.Application)System.Runtime.InteropServices.
                    Marshal.GetActiveObject("Word.Application");

            oApp.ActiveDocument.Select();
            Word.Selection selection = oApp.Selection;
            Word.Font font = selection.Font;

            if (fontDialog1.ShowDialog() == DialogResult.OK)
            {
                font.Bold           = fontDialog1.Font.Bold ? 1 : 0;
                font.Italic         = fontDialog1.Font.Italic ? 1 : 0;
                font.Underline      = fontDialog1.Font.Underline ? 
                    Word.WdUnderline.wdUnderlineSingle : Word.WdUnderline.wdUnderlineNone;

                font.Size           = fontDialog1.Font.Size;
                font.Name           = fontDialog1.Font.Name;
                font.StrikeThrough  = fontDialog1.Font.Strikeout ? 1 : 0;                
            }
        }
    }
}
